// Vse, kar je za dvojno poševnico (//), je komentar - to vrstico bo prevajalnik ignoriral.

/* Alternativno lahko za komentarje uporabljamo kombinacijo
poševnice (/) in zvezdice (*). Tak način komentiranja se po
navadi uporablja za daljše komentarje, ki se raztezajo čez
več vrstic. Z znakom, ki sledi, bo konec komentarja. */


// Vključimo potrebne knjižnice
// Najprej komunikacijske (SPI)
#include <Wire.h>
#include <SPI.h>
// Nato še senzorske (BMP280)
#include <Adafruit_Sensor.h>
#include <Adafruit_BMP280.h>

// Opišemo, kako bomo priključili naš senzor
#define BMP_SCK 13
#define BMP_MISO 12
#define BMP_MOSI 11 
#define BMP_CS 10

// Definiramo naš objekt - bmp
Adafruit_BMP280 bmp(BMP_CS, BMP_MOSI, BMP_MISO,  BMP_SCK);

// Ta funkcija se požene samo, ko priključimo Arduino na napajanje
void setup() {
  Serial.begin(9600);

  // Inicializiramo BMP280 in preverimo, če je šlo kaj narobe.
  if (!bmp.begin()) {  
    // Ta del se bo izvajal, samo če gre kaj narobe: Izpišemo napako in se zapletemo v neskončno zanko.
    Serial.println(F("Ne najdem senzorja BMP280!"));
    while (1);
  }
}

// Ta funkcija se poganja vedno znova
void loop() {
    Serial.print(F("Temperatura = "));
    Serial.print(bmp.readTemperature());
    Serial.println(" °C");
     
    Serial.print(F("Tlak = "));
    Serial.print(bmp.readPressure());
    Serial.println(" Pa");
     
    Serial.println();
    // 2s=2000ms
    delay(2000);
}
