// Vse, kar je za dvojno poševnico (//), je komentar - to vrstico bo prevajalnik ignoriral.

/* Alternativno lahko za komentarje uporabljamo kombinacijo
poševnice (/) in zvezdice (*). Tak način komentiranja se po
navadi uporablja za daljše komentarje, ki se raztezajo čez
več vrstic. Z znakom, ki sledi, bo konec komentarja. */


// Vključimo potrebne knjižnice
// Najprej senzorske
#include <DallasTemperature.h> 
// Najto komunikacijske (1wire)
#include <OneWire.h>              
 
// Določimo komunikacijski pin
#define Signal_PIN 4
 
// Deklariramo senzorjev objekt sensors (s pomočjo komunikacijkega oneWire)
OneWire oneWire(Signal_PIN);          
DallasTemperature sensors(&oneWire);   
 
// Ta funkcija se požene samo, ko priključimo Arduino na napajanje
void setup() {
    Serial.begin(9600);
    Serial.println("Inicializacija senzorja DS18B20");
    sensors.begin();  
}
 
// Ta funkcija se poganja vedno znova
void loop()
{
    // Najprej preberemo temperaturo s senzorja
    sensors.requestTemperatures(); 
    // Nato jo prikažemo
    Serial.print("Temperatura: ");
    Serial.print(sensors.getTempCByIndex(0));
    Serial.println("°C");

    // 1s=1000ms
    delay(1000);
}
