// Vse, kar je za dvojno poševnico (//), je komentar - to vrstico bo prevajalnik ignoriral.

/* Alternativno lahko za komentarje uporabljamo kombinacijo
poševnice (/) in zvezdice (*). Tak način komentiranja se po
navadi uporablja za daljše komentarje, ki se raztezajo čez
več vrstic. Z znakom, ki sledi, bo konec komentarja. */

// Vključimo knjižnico za DHT senzor
#include <DHT.h>
 
// Na kateri pin bomo priključili DHT
#define DHTPIN 2     
 
// Tip senzorja v našem primeru je DHT11
#define DHTTYPE DHT11

// Tu definiramo DHT objekt
DHT dht(DHTPIN, DHTTYPE);

// Ta funkcija se požene samo, ko priključimo Arduino na napajanje
void setup() 
{
  Serial.begin(9600);
  Serial.println("Test modula KY-015 - senzor za temperaturo in vlago:");
 
  // Poženemo DHT
  dht.begin();
}
 
// Ta funkcija se poganja vedno znova
void loop() {
 
  // Pošakamo 2s=2000ms
  delay(2000);
 
  // Preberemo vlažnost in jo zapišemo v spremenljivko h.
  // Ker je h prvič uvedena na tem mestu, jo še definiramo - float pomeni realno število.
  float h = dht.readHumidity();
  // Isto s temperaturo.
  float t = dht.readTemperature();
   
  // Preverimo, ali imata spremenljivki t in h smiselne vrednosti (nan pomeni Not A Number).
  if (isnan(h) || isnan(t)) {
    Serial.println("Error while reading the sensor");
    return;
  }
 
  // Izpišemo rezultate
  Serial.println("-----------------------------------------------------------");
  Serial.print("Vlaga: ");
  Serial.print(h);
  // \t izpiše tabulator
  Serial.print(" %\t");
  Serial.print("temperatura: ");
  Serial.print(t);
  Serial.print(char(186)); // Koda za stopinjo (°)
  Serial.println("C ");
  Serial.println("-----------------------------------------------------------");
  Serial.println(" ");
}

