// Vse, kar je za dvojno poševnico (//), je komentar - to vrstico bo prevajalnik ignoriral.

/* Alternativno lahko za komentarje uporabljamo kombinacijo
poševnice (/) in zvezdice (*). Tak način komentiranja se po
navadi uporablja za daljše komentarje, ki se raztezajo čez
več vrstic. Z znakom, ki sledi, bo konec komentarja. */

// Določimo ustrezen pin. Pozor na A pred 5!
int sensorPin = A5;
 
// Ta funkcija se požene samo, ko priključimo Arduino na napajanje
void setup()
{
    Serial.begin(9600);
}
 
// Ta funkcija se poganja vedno znova 
void loop()
{      
    // Preberemo surovo vrednost z ADC-ja v rawValue, ki je celo število (tipa int).
    int rawValue = analogRead(sensorPin);
    // ADC je 10-bitni (vrednosti od 0 do 1023). 0 predstavlja 0V, 1023 pa 5V.
    // Vrednost zapišemo v spremenljivko voltage, ki je realno število (tipa float).
    float voltage = rawValue * (5.0/1023) * 1000;
    // Upornost dobimo s pomočjo napetostnega delilnika. Fotorezistor je zaporedno vezan na 10k upornik.
    float resitance = 10000 * ( voltage / ( 5000.0 - voltage) );
         
    // Prikažemo rezultate
    Serial.print("U = "); Serial.print(voltage); Serial.print("mV");
    Serial.print(", R = "); Serial.print(resitance); Serial.println("Ohm");
    Serial.println("---------------------------------------");

    // 1s = 1000ms
    delay(1000);
}
