// Vse, kar je za dvojno poševnico (//), je komentar - to vrstico bo prevajalnik ignoriral.

/* Alternativno lahko za komentarje uporabljamo kombinacijo
poševnice (/) in zvezdice (*). Tak način komentiranja se po
navadi uporablja za daljše komentarje, ki se raztezajo čez
več vrstic. Z znakom, ki sledi, bo konec komentarja. */

// Določimo analogni in digitalni pin
int Analog_Pin = A0;
int Digital_Pin = 3;
  
// Ta funkcija se požene samo, ko priključimo Arduino na napajanje
void setup ()
{
  pinMode (Analog_Pin, INPUT);
  pinMode (Digital_Pin, INPUT);
       
  Serial.begin (9600);
}
  

// Ta funkcija se poganja vedno znova
void loop ()
{
  // Definicija spremenljivk: Analog bo realno število, Digital celo.
  float Analog;
  int Digital;
    
  // Preberemo oba pina
  // ADC je 10-bitni (vrednosti od 0 do 1023). 0 predstavlja 0V, 1023 pa 5V.
  Analog = analogRead (Analog_Pin) * (5.0 / 1023.0); 
  Digital = digitalRead (Digital_Pin);
    
  // Izpis
  Serial.print ("Napetost na modulu:"); Serial.print (Analog, 4);  Serial.print ("V, ");
  Serial.print ("Mejna vrednost: ");
  
  if(Digital==1)
  {
      Serial.println ("presežena");
  }
  else
  {
      Serial.println ("ni presežena");
  }
  Serial.println ("----------------------------------------------------------------");

  // 1s=1000ms
  delay (1000);
}
