// Vse, kar je za dvojno poševnico (//), je komentar - to vrstico bo prevajalnik ignoriral.

/* Alternativno lahko za komentarje uporabljamo kombinacijo
poševnice (/) in zvezdice (*). Tak način komentiranja se po
navadi uporablja za daljše komentarje, ki se raztezajo čez
več vrstic. Z znakom, ki sledi, bo konec komentarja. */

// Določimo ustrezna pina
#define Echo_Pin 7 // Echo input-pin
#define Trigger_Pin 8 // Trigger output-pin
 
// Razne spremenljivke
int maximumRange = 300; 
int minimumRange = 2; 
long Dist;
long Time;

// Ta funkcija se požene samo, ko priključimo Arduino na napajanje
void setup() {
 // Trigger pin bo izhodni
 pinMode(Trigger_Pin, OUTPUT);
 // Echo pa vhodni
 pinMode(Echo_Pin, INPUT);
 Serial.begin (9600);
}


// Ta funkcija se poganja vedno znova 
void loop() {
 // Z 10 us visokim signalom na trigger pinu sprožimo meritev
 digitalWrite(Trigger_Pin, HIGH);
 delayMicroseconds(10); 
 digitalWrite(Trigger_Pin, LOW);
  
 // Počakamo, koliko časa (v us) bo echo pin visok
 Time = pulseIn(Echo_Pin, HIGH);
  
 // Hitrost zvoka v zraku je 343,2m/s. Zvok prepotuje dvojno pot.
 Dist = Time*0.01716;
  
 // Po specifikaciji deluje senzor samo v določenem območju.
 if (Dist >= maximumRange || Dist <= minimumRange)
 {
      Serial.println("Razdalja izven veljavnega območja.");
      Serial.println("-----------------------------------");
 }  
  
 else
 {
    // Izpišemo razdaljo
      Serial.print("Razdalja je: ");
      Serial.print(Dist);
      Serial.println(" cm");
      Serial.println("-----------------------------------");
 }
  // 1s=1000ms
 delay(2000);
}
